/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.util;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.LauncherHelper;
import com.install4j.runtime.util.Base64;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Stack;

public class SingleInstance {
    private static final Stack<String> performedStartups = new Stack();
    private static final int NOTIFICATION_WAIT_TIME = Integer.getInteger("install4j.notificationWaitTime", 5);
    private static final String FINISHED_SUFFIX = ".f";
    private static SingleInstanceListener listener;
    private static boolean checkUsedForCurrentLauncher;

    public static synchronized void checkForCurrentLauncher(File launcherPath, boolean global, String[] arguments) {
        if (!checkUsedForCurrentLauncher) {
            checkUsedForCurrentLauncher = true;
            try {
                Runnable shutdownRunnable = SingleInstance.check(launcherPath, global, arguments);
                if (shutdownRunnable == null) {
                    System.exit(0);
                } else {
                    Runtime.getRuntime().addShutdownHook(new Thread(shutdownRunnable));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkInProcessAndRun(File launcherPath, Runnable runnable) {
        Runnable shutdownRunnable = null;
        try {
            shutdownRunnable = SingleInstance.check(launcherPath, false, null);
            if (shutdownRunnable == null) {
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            runnable.run();
        }
        finally {
            if (shutdownRunnable != null) {
                shutdownRunnable.run();
            }
        }
        return true;
    }

    private static synchronized Runnable check(File launcherPath, boolean global, String[] arguments) throws IOException {
        block13: {
            File lockFile;
            String userName = System.getProperty("user.name", "");
            File baseDir = SingleInstance.getLockFileDir();
            baseDir.mkdirs();
            if (global) {
                File globalFileDir = new File(baseDir, "i4j_launcher_locks");
                if (globalFileDir.mkdir()) {
                    LauncherHelper.INSTANCE.setPosixFilePermissions(globalFileDir, "777");
                }
                lockFile = new File(globalFileDir, "i4j_" + SingleInstance.getPathHash(launcherPath, "") + ".lock");
            } else {
                lockFile = new File(baseDir, "i4j_" + SingleInstance.getPathHash(launcherPath, userName) + ".lock");
            }
            final File notificationDir = new File(baseDir, "i4j_" + SingleInstance.getPathHash(launcherPath, userName) + ".notify");
            boolean locked = true;
            final RandomAccessFile randomAccessFile = new RandomAccessFile(lockFile, "rw");
            try {
                FileLock fileLock = randomAccessFile.getChannel().tryLock();
                if (fileLock == null) {
                    locked = false;
                }
            }
            catch (OverlappingFileLockException e) {
                locked = false;
            }
            if (locked) {
                if (global) {
                    LauncherHelper.INSTANCE.setPosixFilePermissions(lockFile, "666");
                }
                Runnable shutdownRunnable = new Runnable(){

                    @Override
                    public void run() {
                        notificationDir.delete();
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        lockFile.delete();
                    }
                };
                if (arguments != null) {
                    SingleInstance.createStartupListener(notificationDir);
                }
                return shutdownRunnable;
            }
            randomAccessFile.close();
            if (!Launcher.JAVA_1_6 && arguments != null) {
                boolean longWait = true;
                if (global) {
                    String lockFileOwner = LauncherHelper.INSTANCE.getUnixOwner(lockFile);
                    longWait = lockFileOwner == null || !SingleInstance.isValidUserName(userName) || lockFileOwner.equals(userName);
                }
                try {
                    SingleInstance.notifyLaunch(arguments, notificationDir, longWait);
                }
                catch (Exception e) {
                    if (!Boolean.getBoolean("install4j.debugStartupNotification")) break block13;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static boolean isValidUserName(String userName) {
        return !userName.isEmpty() && !userName.startsWith("?");
    }

    private static void createStartupListener(final File notificationDir) {
        LauncherHelper.INSTANCE.watchDirectory(notificationDir, "700", "install4j startup listener", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File[] files = notificationDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(SingleInstance.FINISHED_SUFFIX);
                    }
                });
                if (files != null) {
                    for (File file : files) {
                        String arguments = SingleInstance.readArguments(file);
                        file.delete();
                        Stack stack = performedStartups;
                        synchronized (stack) {
                            if (listener != null) {
                                listener.startupPerformed(arguments);
                            } else {
                                performedStartups.push(arguments);
                            }
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readArguments(File file) {
        ArrayList<String> args = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String arg = reader.readLine();
            while (arg != null) {
                args.add(arg);
                arg = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (args.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            if (builder.length() > 0 && arg.length() > 0) {
                builder.append(" ");
            }
            builder.append(SingleInstance.quoteArgument(arg));
        }
        return builder.toString();
    }

    private static String quoteArgument(String argument) {
        if (argument.contains("\"")) {
            return '\'' + argument + '\'';
        }
        if (argument.contains("'") || argument.contains(" ")) {
            return '\"' + argument + '\"';
        }
        return argument;
    }

    private static void notifyLaunch(String[] arguments, File notificationDir, boolean longWait) throws IOException {
        if (longWait) {
            for (int i = 0; i < 10 * NOTIFICATION_WAIT_TIME && !notificationDir.isDirectory(); ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else if (!notificationDir.isDirectory()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (notificationDir.isDirectory()) {
            File tempFile = File.createTempFile("launch", ".tmp", notificationDir);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tempFile)), "UTF-8"));
            for (String argument : arguments) {
                pw.println(argument);
            }
            pw.close();
            tempFile.renameTo(new File(notificationDir, tempFile.getName() + FINISHED_SUFFIX));
        }
    }

    private static File getLockFileDir() {
        return new File(System.getProperty("install4j.lockFileDir", System.getProperty("java.io.tmpdir")));
    }

    public static String getPathHash(File installationPath, String suffix) {
        String pathHash = "unknown";
        try {
            pathHash = Base64.encodeForFiles(MessageDigest.getInstance("SHA-1").digest((FileUtil.getCanonicalPath(installationPath) + suffix).getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pathHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerStartupListener(SingleInstanceListener listener) {
        Stack<String> stack = performedStartups;
        synchronized (stack) {
            SingleInstance.listener = listener;
            if (listener != null) {
                while (!performedStartups.empty()) {
                    listener.startupPerformed(performedStartups.pop());
                }
            }
        }
    }

    static {
        checkUsedForCurrentLauncher = false;
    }

    public static interface SingleInstanceListener {
        public void startupPerformed(String var1);
    }
}

