/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32.wininet;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.installer.platform.win32.wininet.CallImpl;
import com.install4j.runtime.installer.platform.win32.wininet.IgnoreCaseString;
import com.install4j.runtime.installer.platform.win32.wininet.WinInetAuthenticator;
import com.install4j.runtime.installer.platform.win32.wininet.WinInetCall;
import com.install4j.runtime.installer.platform.win32.wininet.WinInetUnavailableException;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WinInet {
    public static final int TIMEOUT_DEFAULT = -2;
    private static final int INTERNET_OPEN_TYPE_PRECONFIG = 0;
    private static final int INTERNET_OPEN_TYPE_DIRECT = 1;
    private static final int INTERNET_OPEN_TYPE_PROXY = 3;
    private static final int INTERNET_OPEN_TYPE_PRECONFIG_WITH_NO_AUTOPROXY = 4;
    private static final int INTERNET_FLAG_NO_CACHE_WRITE = 0x4000000;
    private static final int INTERNET_FLAG_NO_COOKIES = 524288;
    private static final int INTERNET_FLAG_KEEP_CONNECTION = 0x400000;
    private static final int INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP = 32768;
    private static final int INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS = 16384;
    private static final int INTERNET_FLAG_RELOAD = Integer.MIN_VALUE;
    private static final int INTERNET_FLAG_PRAGMA_NOCACHE = 256;
    private static final int INTERNET_FLAG_IGNORE_CERT_CN_INVALID = 4096;
    private static final int INTERNET_FLAG_IGNORE_CERT_DATE_INVALID = 8192;
    private static final int SECURITY_FLAG_IGNORE_REVOCATION = 128;
    private static final int SECURITY_FLAG_IGNORE_UNKNOWN_CA = 256;
    private static final int SECURITY_FLAG_IGNORE_WEAK_SIGNATURE = 65536;
    private static final int SECURITY_FLAG_IGNORE_WRONG_USAGE = 512;
    private static final int INTERNET_FLAG_SECURE = 0x800000;
    static final int ERROR_INTERNET_NAME_NOT_RESOLVED = 12007;
    static final int ERROR_INTERNET_TIMEOUT = 12002;
    static final int ERROR_INTERNET_INCORRECT_PASSWORD = 12014;
    static final int ERROR_INTERNET_SERVER_UNREACHABLE = 12164;
    static final int ERROR_INTERNET_NO_DIRECT_ACCESS = 12023;
    static final int ERROR_INTERNET_CANNOT_CONNECT = 12029;
    static final int ERROR_INTERNET_NOT_PROXY_REQUEST = 12020;
    static final int ERROR_INTERNET_PROXY_SERVER_UNREACHABLE = 12165;
    static final int ERROR_INTERNET_FORCE_RETRY = 12032;
    private static final int ERROR_INTERNET_SEC_CERT_CN_INVALID = 12038;
    private static final int ERROR_INTERNET_SEC_CERT_DATE_INVALID = 12037;
    private static final int ERROR_INTERNET_INVALID_CA = 12045;
    private static final int ERROR_INTERNET_SEC_CERT_ERRORS = 12055;
    private static final int ERROR_INTERNET_SEC_CERT_NO_REV = 12056;
    private static final int ERROR_INTERNET_SEC_CERT_REV_FAILED = 12057;
    private static final int ERROR_INTERNET_SEC_CERT_REVOKED = 12170;
    private static final int ERROR_INTERNET_SEC_INVALID_CERT = 12169;
    private static final int ERROR_INTERNET_SECURITY_CHANNEL_ERROR = 12157;
    private static final int FLAGS_ERROR_UI_FILTER_FOR_ERRORS = 1;
    private static final int FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS = 2;
    private static final int FLAGS_ERROR_UI_FLAGS_GENERATE_DATA = 4;
    private static final int FLAGS_ERROR_UI_FLAGS_NO_UI = 8;
    private static final int FLAGS_ERROR_UI_SERIALIZE_DIALOGS = 16;
    private static final int INTERNET_OPTION_CONNECT_TIMEOUT = 2;
    private static final int INTERNET_OPTION_RECEIVE_TIMEOUT = 6;
    private static final int INTERNET_OPTION_USERNAME = 28;
    private static final int INTERNET_OPTION_PASSWORD = 29;
    private static final int INTERNET_OPTION_PROXY_USERNAME = 43;
    private static final int INTERNET_OPTION_PROXY_PASSWORD = 44;
    private static Boolean available;
    private static final ProxyConfig DEFAULT_PROXY_CONFIG;

    private static native boolean init0();

    private static native String getErrorMessage0(int var0);

    static native int getErrorCode0(long var0);

    static native int getErrorLocation0(long var0);

    static native void clearError0(long var0);

    static native void destroy0(long var0);

    private static native long connect0(String var0, int var1, String var2, String var3, int var4, String var5, int var6, int var7);

    private static native void openRequest0(long var0, String var2, String var3, int var4, int var5);

    static native byte[] getHeaders0(long var0);

    static native int read0(long var0, byte[] var2, int var3, int var4);

    private static native int internetErrorDlg0(long var0, int var2, int var3, long var4);

    static native int sendRequest0(long var0, String var2, byte[] var3);

    private static native void setOption0(long var0, int var2, byte[] var3);

    private static native void setDwordOption0(long var0, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WinInetCall open(String userAgent, String urlString, Map<IgnoreCaseString, List<String>> headers, String method, long contentLength, boolean ignoreCertificateErrors, int connectTimeout, int readTimeout, @Nullable ProxyConfig proxyConfig, WinInetAuthenticator proxyAuthenticator) throws IOException {
        if (!Util.isWindows()) {
            throw new WinInetUnavailableException("not windows");
        }
        Class<WinInet> clazz = WinInet.class;
        synchronized (WinInet.class) {
            if (available == null) {
                available = WinInet.init0();
            }
            // ** MonitorExit[var11_10] (shouldn't be in output)
            if (!available.booleanValue()) {
                throw new WinInetUnavailableException("functions not found");
            }
            if (proxyConfig == null) {
                proxyConfig = DEFAULT_PROXY_CONFIG;
            }
            URI uri = URI.create(urlString);
            boolean https = uri.getScheme().equalsIgnoreCase("https");
            long address = WinInet.connect0(userAgent, proxyConfig.type.intValue, proxyConfig.proxy, proxyConfig.bypass, 0, uri.getHost(), WinInet.getPort(uri, https), 0);
            if (address != 0L) {
                if (contentLength > 0L) {
                    headers = headers == null ? new HashMap<IgnoreCaseString, List<String>>() : new HashMap<IgnoreCaseString, List<String>>(headers);
                    headers.put(new IgnoreCaseString("Content-Length"), Collections.singletonList(String.valueOf(contentLength)));
                }
                CallImpl call = new CallImpl(address, uri, contentLength, WinInet.buildHeaders(headers), proxyAuthenticator);
                int additionalSecurityFlags = 0;
                int flags = -2075607040;
                if (https) {
                    flags |= 0x800000;
                    if (ignoreCertificateErrors) {
                        flags |= 0x3000;
                        additionalSecurityFlags = 66432;
                    }
                }
                WinInet.openRequest0(call.getAddress(), method, WinInet.buildObject(uri), flags, additionalSecurityFlags);
                call.checkExceptionAndClose();
                if (connectTimeout != -2) {
                    WinInet.setDwordOption(call, 2, connectTimeout);
                }
                if (readTimeout != -2) {
                    WinInet.setDwordOption(call, 6, readTimeout);
                }
                if (contentLength <= 0L) {
                    call.sendRequest();
                }
                return call;
            }
            throw new IOException("no address");
        }
    }

    static void handleAuthentication(boolean proxyAuth, WinInetAuthenticator authenticator, CallImpl call) throws IOException {
        if (authenticator.isShowUi(proxyAuth)) {
            int dialogFlags = 7;
            int dialogReturn = WinInet.internetErrorDlg0(call.getAddress(), 12014, dialogFlags, authenticator.hwnd);
            call.checkExceptionAndClose();
            if (dialogReturn != 12032) {
                throw new RuntimeException(new UserCanceledException());
            }
        } else if (proxyAuth) {
            WinInet.useSupplier(call, authenticator.proxySupplier, "proxy", 43, 44);
        } else {
            WinInet.useSupplier(call, authenticator.serverSupplier, "server", 28, 29);
        }
    }

    private static void useSupplier(CallImpl call, Supplier<PasswordAuthentication> supplier, String type, int userNameField, int passwordField) throws IOException {
        PasswordAuthentication passwordAuthentication = supplier.get();
        if (passwordAuthentication == null) {
            throw new IOException(type + " authentication required");
        }
        WinInet.setStringOption(call, userNameField, passwordAuthentication.getUserName());
        WinInet.setStringOption(call, passwordField, passwordAuthentication.getPassword() == null ? null : new String(passwordAuthentication.getPassword()));
    }

    private static void setStringOption(CallImpl call, int option, String str) throws IOException {
        byte[] data = null;
        if (str != null) {
            data = (str + '\u0000').getBytes(StandardCharsets.UTF_16LE);
        }
        WinInet.setOption0(call.getAddress(), option, data);
        call.checkExceptionAndClose();
    }

    private static void setDwordOption(CallImpl call, int option, int value) throws IOException {
        WinInet.setDwordOption0(call.getAddress(), option, value);
        call.checkExceptionAndClose();
    }

    private static int getPort(URI uri, boolean https) {
        int port = uri.getPort();
        if (port == -1) {
            if (https) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    @NotNull
    private static String buildObject(URI uri) {
        StringBuilder objectBuilder = new StringBuilder();
        objectBuilder.append(uri.getRawPath() != null ? uri.getRawPath() : "/");
        if (uri.getRawQuery() != null) {
            objectBuilder.append("?");
            objectBuilder.append(uri.getRawQuery());
        }
        return objectBuilder.toString();
    }

    @Nullable
    private static String buildHeaders(Map<IgnoreCaseString, List<String>> headers) {
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        StringBuilder headerBuilder = new StringBuilder();
        for (Map.Entry<IgnoreCaseString, List<String>> entry : headers.entrySet()) {
            for (String value : entry.getValue()) {
                headerBuilder.append(entry.getKey().getDisplayString()).append(": ").append(value).append("\r\n");
            }
        }
        return headerBuilder.toString();
    }

    @NotNull
    static String getDefaultExceptionMessage(int errorLocation, int errorCode) {
        return "wininet error code " + errorCode + " (loc: " + errorLocation + ")" + WinInet.getWindowsMessageSuffix(errorCode);
    }

    static boolean isSslError(int errorCode) {
        return errorCode == 12038 || errorCode == 12037 || errorCode == 12045 || errorCode == 12055 || errorCode == 12056 || errorCode == 12057 || errorCode == 12170 || errorCode == 12169 || errorCode == 12157;
    }

    @NotNull
    private static String getWindowsMessageSuffix(int errorCode) {
        String windowsMessage = "";
        if (errorCode != 0 && !(windowsMessage = WinInet.getErrorMessage0(errorCode)).isEmpty()) {
            windowsMessage = ": " + windowsMessage;
        }
        return windowsMessage;
    }

    static {
        Common.init();
        DEFAULT_PROXY_CONFIG = new ProxyConfig(ProxyType.PRECONFIG, null, null);
    }

    public static enum ProxyType {
        PRECONFIG(0),
        DIRECT(1),
        PROXY(3),
        PRECONFIG_WITH_NO_AUTOPROXY(4);

        private final int intValue;

        private ProxyType(int intValue) {
            this.intValue = intValue;
        }
    }

    public static class ProxyConfig {
        private final ProxyType type;
        private final String proxy;
        private final String bypass;

        public ProxyConfig(@NotNull ProxyType type, @Nullable String proxy, @Nullable String bypass) {
            this.type = type;
            this.proxy = proxy;
            this.bypass = bypass;
        }
    }
}

